


uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define surfacePosition vec2(gl_FragCoord.xy/iResolution)

/////////////////////////////////////////////////////////////////////////////////

// By Michael Pohoreski
// [2TC 15] Monochrome Monopole Log
// Copyleft {c} 2015 Michael Pohoreski
#define F(y) (log(y))
void main(void)
{
    vec2  uv     = 10.0*gl_FragCoord.xy/iResolution.xy - 10.0;
    float time  = atan(uv.y,uv.x);
    float twist  = fract( 100.*time + 0.2*iGlobalTime - 320.0*12.*F(length(uv)));
    float color  = float(twist > 0.5);
    gl_FragColor = vec4( color, color, color, 1.0);
}

